IF EXISTS (select * from sysobjects where name like '%T_Insert_Servidor%')
DROP TRIGGER T_Insert_Servidor
go

CREATE TRIGGER T_Insert_Servidor
ON  Servidor
FOR INSERT, UPDATE
AS

	---------- WebManager ----------
	DECLARE @CodigoServidor NVARCHAR(30);
	DECLARE @FechaActivacion DATETIME;
	DECLARE @Etiqueta NVARCHAR(200);
	DECLARE @IP NVARCHAR(50);
	DECLARE @Puerto DECIMAL(10,0);
	DECLARE @FechaUltimaConexion DATETIME;
	DECLARE @IdZonaAux DECIMAL(20,0);
	DECLARE @Activo BIT;
	DECLARE @IdCliente DECIMAL(20,0) = 1;
	DECLARE Elems_Cursor11111 CURSOR FOR
	SELECT CodigoServidor,FechaActivacion,Etiqueta,IP,Puerto,FechaUltimaConexion,IdZona,Activo FROM INSERTED;
	OPEN Elems_Cursor11111
	
	FETCH NEXT FROM Elems_Cursor11111 INTO @CodigoServidor,@FechaActivacion,@Etiqueta,@IP,@Puerto,@FechaUltimaConexion,@IdZonaAux,@Activo
	WHILE @@FETCH_STATUS = 0
	BEGIN	
	
		PRINT 'Migrar datos a tablas WebManager'

		--En caso de que la zona tenga servidores vinculados, actualizamos a 1 el valor de TieneServidores, si no a 0
		IF (SELECT COUNT(*) FROM WM_CodigoServidor WHERE CodigoServidor=@CodigoServidor) > 0
		BEGIN
			UPDATE WM_CodigoServidor SET Activo=@Activo WHERE WM_CodigoServidor.CodigoServidor=@CodigoServidor
			UPDATE WM_ServidorCliente SET FechaActivacion=@FechaActivacion,Etiqueta=@Etiqueta,IP=@IP,Puerto=@Puerto,FechaUltimaConexion=@FechaUltimaConexion,IdZona=@IdZonaAux WHERE WM_ServidorCliente.CodigoServidor=@CodigoServidor 
		END
		ELSE
		BEGIN
			INSERT INTO WM_CodigoServidor (CodigoServidor,FechaAlta,Activo) VALUES (@CodigoServidor,getdate(),@Activo)
			INSERT INTO WM_ServidorCliente (IdCliente,CodigoServidor,FechaActivacion,Etiqueta,IP,Puerto,FechaUltimaConexion,IdZona) VALUES (@IdCliente,@CodigoServidor,@FechaActivacion,@Etiqueta,@IP,@Puerto,@FechaUltimaConexion,@IdZonaAux)
		END

		PRINT 'Fin migrar datos a tablas WebManager'

	FETCH NEXT FROM Elems_Cursor11111 INTO @CodigoServidor,@FechaActivacion,@Etiqueta,@IP,@Puerto,@FechaUltimaConexion,@IdZonaAux,@Activo
	END
	
	CLOSE Elems_Cursor11111
	DEALLOCATE Elems_Cursor11111

	---------- Fin WebManager ----------


	DECLARE @IdZona DECIMAL(20,0);
	DECLARE @IdZona_Aux DECIMAL(20,0);
	DECLARE Elems_Cursor222 CURSOR FOR
	SELECT IsNull(IdZona,-1) FROM INSERTED;
	OPEN Elems_Cursor222

	FETCH NEXT FROM Elems_Cursor222 INTO @IdZona
	WHILE @@FETCH_STATUS = 0
	BEGIN	
	
		PRINT 'IdZona ' + CONVERT(VARCHAR(100),@IdZona);

		IF @IdZona != -1
		BEGIN
			--En caso de que el servidor tenga zona vinculada, hacemos la proteccin que la zona sea zona final
			IF (SELECT COUNT(*) FROM Zona WHERE Zona.IdZonaPadre=@IdZona) = 0
			BEGIN
				UPDATE Zona SET TieneServidores=1 WHERE Zona.IdZona=@IdZona
			END
		END

		PRINT 'Ejecucion trigger T_Insert_Servidor.'

	FETCH NEXT FROM Elems_Cursor222 INTO @IdZona
	END

	CLOSE Elems_Cursor222
	DEALLOCATE Elems_Cursor222

	--Calculamos para el resto de zonas del sistema que sean zonas finales (no tienen hijos) el valor de TieneServidores
	DECLARE Elems_Cursor444 CURSOR FOR 
	SELECT IdZona FROM Zona WHERE (SELECT COUNT(*) FROM Zona as Zona2 WHERE Zona2.IdZonaPadre=Zona.IdZona) = 0 
	OPEN Elems_Cursor444

	FETCH NEXT FROM Elems_Cursor444 INTO @IdZona_Aux
	WHILE @@FETCH_STATUS = 0
	BEGIN

		--En caso de que la zona tenga servidores vinculados, actualizamos a 1 el valor de TieneServidores, si no a 0
		IF (SELECT COUNT(*) FROM Servidor WHERE IsNull(Servidor.IdZona,-1)=@IdZona_Aux) > 0
		BEGIN
			UPDATE Zona SET TieneServidores=1 WHERE Zona.IdZona=@IdZona_Aux
		END
		ELSE
		BEGIN
			UPDATE Zona SET TieneServidores=0 WHERE Zona.IdZona=@IdZona_Aux
		END
		
	FETCH NEXT FROM Elems_Cursor444 INTO @IdZona_Aux
	END

	CLOSE Elems_Cursor444
	DEALLOCATE Elems_Cursor444

GO
ALTER TABLE Servidor ENABLE TRIGGER T_Insert_Servidor
GO